<?php

/**
 * Plugin Name: Chestmoney WooCommerce Payment Gateway
 * Plugin URI: https://www.chestmoney.com/developers
 * Description: WooCommerce payment gateway for chestmoney
 * Version: 1.0.0
 * Author: Chestmoney
 * Author URI: https://www.chestmoney.com
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Requires Plugins: woocommerce
 * Requires at least: 6.2
 * Requires PHP: 7.4
 * WC requires at least: 8.0
 * WC tested up to: 9.8
 * Text Domain: woo-chestmoney
 * Domain Path: /languages
 */

if (! defined('ABSPATH')) {
	exit;
}

define('WC_CHESTMONEY_MAIN_FILE', __FILE__);
define('WC_CHESTMONEY_URL', untrailingslashit(plugins_url('/', __FILE__)));

define('WC_CHESTMONEY_VERSION', '1.0.0');

/**
 * Initialize Chestmoney WooCommerce payment gateway.
 */
function tbz_wc_chestmoney_init()
{

	load_plugin_textdomain('woo-chestmoney', false, plugin_basename(dirname(__FILE__)) . '/languages');

	if (! class_exists('WC_Payment_Gateway')) {
		add_action('admin_notices', 'tbz_wc_chestmoney_wc_missing_notice');
		return;
	}

	require_once __DIR__ . '/includes/class-wc-gateway-chestmoney.php';

	add_filter('woocommerce_payment_gateways', 'tbz_wc_add_chestmoney_gateway', 99);

	add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'tbz_woo_chestmoney_plugin_action_links');
}
add_action('plugins_loaded', 'tbz_wc_chestmoney_init', 99);

/**
 * Add Settings link to the plugin entry in the plugins menu.
 *
 * @param array $links Plugin action links.
 *
 * @return array
 **/
function tbz_woo_chestmoney_plugin_action_links($links)
{

	$settings_link = array(
		'settings' => '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=chestmoney') . '" title="' . __('View Chestmoney WooCommerce Settings', 'woo-chestmoney') . '">' . __('Settings', 'woo-chestmoney') . '</a>',
	);

	return array_merge($settings_link, $links);
}

/**
 * Add Chestmoney Gateway to WooCommerce.
 *
 * @param array $methods WooCommerce payment gateways methods.
 *
 * @return array
 */
function tbz_wc_add_chestmoney_gateway($methods)
{
	$methods[] = 'WC_Gateway_Chestmoney';

	return $methods;
}

/**
 * Display a notice if WooCommerce is not installed
 */
function tbz_wc_chestmoney_wc_missing_notice()
{
	echo '<div class="error"><p><strong>' . sprintf(__('Chestmoney requires WooCommerce to be installed and active. Click %s to install WooCommerce.', 'woo-chestmoney'), '<a href="' . admin_url('plugin-install.php?tab=plugin-information&plugin=woocommerce&TB_iframe=true&width=772&height=539') . '" class="thickbox open-plugin-details-modal">here</a>') . '</strong></p></div>';
}

add_action(
	'before_woocommerce_init',
	function () {
		if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
		}
	}
);

/**
 * Registers WooCommerce Blocks integration.
 */
function tbz_wc_gateway_chestmoney_woocommerce_block_support()
{
	if (class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
		require_once __DIR__ . '/includes/class-wc-gateway-chestmoney-blocks-support.php';
		add_action(
			'woocommerce_blocks_payment_method_type_registration',
			static function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
				$payment_method_registry->register(new WC_Gateway_Chestmoney_Blocks_Support());
			}
		);
	}
}
add_action('woocommerce_blocks_loaded', 'tbz_wc_gateway_chestmoney_woocommerce_block_support');
