jQuery(function ($) {
  "use strict";

  /**
   * Object to handle Chestmoney admin functions.
   */
  var wc_chestmoney_admin = {
    /**
     * Initialize.
     */
    init: function () {
      $("#woocommerce_chestmoney_api_token").after(
        '<button id="wc-chestmoney-verify-api-token" style="height: 30px; margin-left: 2px; cursor: pointer; border-radius: 4px; border-color: #8c8f94; color: #2c3338;">Verify token <span class="dashicons dashicons-plugins-checked"></span></button>'
      );

      $("#woocommerce_chestmoney_api_token").after(
        '<button class="wc-chestmoney-toggle-secret" style="height: 30px; margin-left: 3px; cursor: pointer; border-radius: 4px; border-color: #8c8f94; color: #2c3338;"><span class="dashicons dashicons-visibility"></span></button>'
      );

      $("#wc-chestmoney-verify-api-token").after(
        '<div id="wc-chestmoney-modal" style="display:none;"><div style="display: flex;justify-content: center;align-items: center;height: 100%;position: relative;"><div id="wc-chestmoney-spinner" class="spinner" style="float:none;margin:0 auto;position: absolute;top: 50%;left: 50%;transform: translate(-50%, -50%);"></div><div id="wc-chestmoney-content-error" style="display:none;text-align:center;"><span class="dashicons dashicons-warning" style="color:red;font-size:45px;width:45px;height:45px;"></span><div style="font-size:24px;font-weight:bold;line-height:24px;margin-top:5px;">Oops!</div><div id="wc-chestmoney-error-message" style="font-size:18px;line-height:24px;margin-top:5px;">API token is invalid.</div></div><div id="wc-chestmoney-content-success" style="display:none;text-align:center;"><span class="dashicons dashicons-yes-alt" style="color:green;font-size:45px;width:45px;height:45px;"></span><div style="font-size:24px;font-weight:bold;line-height:24px;margin-top:5px;">Bravo!</div><div id="wc-chestmoney-success-message" style="font-size:18px;line-height:24px;margin-top:5px;">API token confirmed.</div></div></div></div>'
      );

      $("#wc-chestmoney-verify-api-token").on("click", function (event) {
        event.preventDefault();

        tb_show(
          "Verify API Token",
          "#TB_inline?inlineId=wc-chestmoney-modal&width=300&height=200"
        );

        $("#wc-chestmoney-content-error").hide();
        $("#wc-chestmoney-content-success").hide();
        $("#wc-chestmoney-spinner").addClass("is-active").show();

        let $input = $(this).closest("tr").find(".input-text");

        $.ajax({
          url: "https://www.chestmoney.com/api/v1/verify-token",
          type: "GET",
          contentType: "application/json",
          headers: {
            Authorization: "Bearer " + $input.val(),
            "X-WP-Nonce": wc_chestmoney_admin_params.nonce,
          },
          success: function (response) {
            $("#wc-chestmoney-spinner").removeClass("is-active").hide();
            $("#wc-chestmoney-content-success").show();
          },
          error: function (xhr, status, error) {
            $("#wc-chestmoney-spinner").removeClass("is-active").hide();
            $("#wc-chestmoney-content-error").show();
          },
        });
      });

      $(".wc-chestmoney-toggle-secret").on("click", function (event) {
        event.preventDefault();

        let $dashicon = $(this).closest("button").find(".dashicons");
        let $input = $(this).closest("tr").find(".input-text");
        let inputType = $input.attr("type");

        if ("text" == inputType) {
          $input.attr("type", "password");
          $dashicon.removeClass("dashicons-hidden");
          $dashicon.addClass("dashicons-visibility");
        } else {
          $input.attr("type", "text");
          $dashicon.removeClass("dashicons-visibility");
          $dashicon.addClass("dashicons-hidden");
        }
      });
    },
  };

  wc_chestmoney_admin.init();
});
